# Radiated Connections (Physical Layer)

## Definition
Radiated connections refer to wireless connections where data is transmitted and received through the air using electromagnetic waves. These connections are also known as wireless connections.

## How it Works
1. **Transmission:** Data is converted into electromagnetic waves (such as radio waves or microwaves) and transmitted through the air.
2. **Reception:** The receiving device captures these waves and converts them back into data.

## Types of Radiated Connections
1. **Wi-Fi:** Wi-Fi uses radio waves to provide wireless high-speed internet and network connections.
2. **Bluetooth:** Bluetooth uses radio waves for short-range wireless data transfer between devices.
3. **Cellular Networks:** Cellular networks use radio waves to transmit voice and data to and from mobile devices.
4. **Satellite Communications:** Satellite communications use microwaves to transmit data to and from satellites.

## Role of Radiated Connections in the Physical Layer
The Physical Layer is responsible for transmitting data over the physical medium. In the case of radiated connections, this medium is air. The Physical Layer handles the conversion of data into electromagnetic waves and vice versa, allowing data to be transmitted wirelessly.

#### Key Insights

- Infrared light and lasers have been used for communication in the past, with infrared being used for devices like TV remotes and lasers offering high-speed data transmission capabilities. However, line-of-sight communication is required for both technologies.
- Satellite communication plays a crucial role in providing connectivity in areas where traditional infrastructure is not available. Geostationary satellites remain stationary above a specific location on Earth, allowing for continuous coverage.
- Project Loon, using balloons to provide temporary communication coverage, is especially useful during disasters or in remote areas where traditional infrastructure is lacking. The balloons can be adjusted in height to steer their drift and provide coverage over a broad area.
- Wi-Fi access points can be controlled by software running on a central server, allowing for centralized management and configuration. This provides a holistic view of the network and simplifies the management of multiple access points.
- Cellular communication has evolved through different generations, with each generation increasing speed and capacity. The transition from circuit-switched networks to packet-switched networks enabled the transmission of data alongside voice, leading to more affordable data communication options.
- With 5G, the focus is on a data network where voice becomes just another application. This generation aims to provide even higher speeds and capacity, enabling a wide range of applications and services beyond traditional voice calls.